/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (09/05/07)
 */    
package com.ejie.p06b.util.bd;

import java.sql.Connection;

import javax.naming.Context;
import javax.naming.InitialContext;

import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BParametros;



/**
 * Clase que efectua la conexion con la bd 
 */
class P06BConexionBD {
    
	private Connection cconConexion = null;
    
	/**
     * Constructor vacio
     */
    P06BConexionBD() {
        this(true);
    }
    
    /**
     * Construye una conexion con transacciones o no dependiendo de un booleano
     *
     * @param abolSoloLectura   boolean que indica si la conexion solo se va a utilizar
     *                          para leer datos
     */
    P06BConexionBD(boolean abolSoloLectura) {

       try {
       	
       		Context ctx = new InitialContext();
       		javax.sql.DataSource ds = (javax.sql.DataSource) ctx.lookup (P06BParametros.get("p06b.datasource"));       		
       		cconConexion = ds.getConnection();
       } catch (Exception e) {
       		P06BLog.send(0,this, "Error en la conexion JTS: " + e);
       }          
	   
     } 

    /**
     * Devuelve la conexion
     * 
     * @return Connection conexion requerida
     */
    Connection obtenerConexion() {
        return cconConexion;
    }
}